<?php
/**
 * The header for our theme.
 *
 * @package investor
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="https://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div id="wrapper">
		<div class="content-block">
			<div class="iv-links">
			    <a class="menu-link" href="#menu">&#9776;</a>
				<?php if ( has_nav_menu( 'header' ) ) { ?>
<?php wp_nav_menu( array( 'container' => 'nav', 'container_class' => 'nav', 'menu_id' => 'nav-links', 'theme_location' => 'header' ) ); ?>
					<?php } ?>
					
					
				    <div class="search-box">
						<form role="search" method="get" action="<?php echo esc_url(home_url( '/' )); ?>">
				      <input placeholder="Search..." autocomplete="off" value="" name="s" id="header-s"><span class="icon icon-search"></span>
				   </form>
				    </div>
				</div>
			<header id="header" class="iv-light" >
				
				<div class="header-holder">
					<div class="logo">
						 <?php $sk_logo  = get_theme_mod('logo_image'); 
				          if(!empty($sk_logo)) { ?>
				 	       <a href="<?php echo esc_url(home_url( '/')); ?>"> <img class="a iv-dd" src="<?php echo esc_attr($sk_logo);?>" alt=""> </a>
						   <?php }
				 	   		 else { ?>
						<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
						<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
						<?php } ?>
					</div>
			
					<a href="#" class="nav-opener"><span></span></a>
				    
				       <div class="investor-menu-container">
						   <?php if ( has_nav_menu( 'primary' ) ) { ?>
							<?php wp_nav_menu( array( 'container' => 'div', 'container_class' => 'investor-menu', 'menu_id' => 'primary-menu', 'theme_location' => 'primary' ) ); ?>
							<?php } else { ?>
							<?php wp_nav_menu( array('menu_class' => 'investor-menu') ); ?>
							<?php } ?>
						</div>
				</div>
			</header>