<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package investor
 */

get_header(); 
$url = '';
if ( is_home() && ! is_front_page() ) { 
	
	$thumb = wp_get_attachment_image_src( get_post_thumbnail_id(get_option( 'page_for_posts')), 'large' );
	$url = $thumb['0'];	
}
elseif (get_header_image()) {
	$url = get_header_image();
}
if(get_theme_mod('blog_layout') == 'grid') {
	$ivb = 'iv-grid';
} else {
	$ivb = '';
}
?>
		<header class="iv-fade iv-adjust">
		  <div class="headline" style="background:url(<?php if($url) { echo esc_url($url); } ?>) no-repeat center center / cover;">
		    <div class="inner">
				<?php if ( is_home() && ! is_front_page() ) { ?>
					
						<h1><?php single_post_title(); ?></h1>
		  	   	  <?php if ( function_exists( 'get_field' ) ) : ?>
		  	         <p><?php the_field('page_subtitle', get_option('page_for_posts')); ?></p>
		  	           <?php endif; ?>

				<?php
			} else { ?>
					<h1 class="entry-title"><?php esc_html_e('Latest Posts','investor'); ?></h1>
					<?php } ?>
		      </div>
		  </div>
		</header>
		
		
	<main id="main" class="<?php echo esc_attr($ivb); ?>">
		
		<div id="content">
			<div class="container">

		<?php
		
if ( have_posts() ) :
			

				/*
				 * Include the Post-Format-specific template for the content.
				 * If you want to override this in a child theme, then include a file
				 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
				 */
				
				if(get_theme_mod('blog_layout') == 'grid') { ?>
				<ul class="cards iv-posts">
					
					<?php 
					
					while ( have_posts() ) : the_post(); ?>
				<?php get_template_part( 'template-parts/content', 'grid' ); ?>
				<?php endwhile; ?>
			</ul>
			<?php } else {
				
				while ( have_posts() ) : the_post(); 
			get_template_part( 'template-parts/content', get_post_format() );
			endwhile;
		}?>
		<?php 
			
			

		else :

			get_template_part( 'template-parts/content', 'none' );

		endif; ?>
				</div>
				
				<?php investor_paging_nav(); ?>
				
	</div><!-- #primary -->
	
		</main><!-- #main -->
	

<?php
//get_sidebar();
get_footer();
