<?php
/**
 * Template part for displaying events.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Investor
 */

?>
					<article id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>>
						<div class="detail iv-center">
						   <?php $ids = get_field('link_to_profile');
						
						   if($ids) :
							 foreach($ids as $id) : ?>
							 <a href="<?php echo esc_url(get_permalink($id)); ?>">
							 <div class="iv-pro">
							<img class="fund-img" src="<?php the_field('image', $id); ?>"/>
							<h3><?php the_field('name', $id); ?></h3></a>
							<?php the_field('position', $id); ?>
						</div>
							<?php endforeach; endif; 
						if( have_rows('line_items') ): ?>
							   <div class="iv-details-table">
							 <h3><?php the_field('title'); ?></h3>
						   <table class="iv-fund" border="0">
							   <tbody>
								   <tr>
								   <?php while( have_rows('line_items') ): the_row(); ?>
										<td data-label="<?php the_sub_field('heading'); ?>"><?php the_sub_field('text'); ?></td>											
						  				 <?php endwhile; ?>
						  						</tr>						
						  							</tbody>
						  						  	</table>
												</div>
													<?php endif; ?>
						</div>
						<div class="text">
						<?php 
						the_title( '<h1>','</h1>' );  ?>
						<div class="fund-subtext">
						<?php if ( function_exists( 'get_field' )  ) { echo esc_attr(get_field('page_subtitle')); } ?>
					</div>
					<?php
						if ( function_exists( 'get_field' )  ) {
									get_template_part( 'template-parts/content', 'fundpb' );
							} else {		?>
							<?php the_content(); 
						} ?>
						</div>
					</article>
					
				