<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Investor
 */

?>
						

					
				     <li <?php post_class('post cards-item'); ?> id="post-<?php the_ID(); ?>">
						
				       <div class="iv-card">
						   <div class="iv-date">
							<?php the_time('M') ?>
							<span><?php the_time('j') ?></span>
							<?php the_time('Y') ?>
						 </div>
						  <div class="iv-card-image">
						 		<?php if ( function_exists( 'get_field' ) && has_post_format( 'video' ) ) { ?>
						 			<div class="investor-vid">
						 		   <?php ( wp_oembed_get( get_field( 'post_video' ), array('width'=>700)) ); ?>
						 	   </div>
						 			 <?php  
						 		} 
								elseif ( function_exists( 'get_field' ) && has_post_format( 'gallery' ) ) {
								if (get_field('post_gallery')): ?>
									<div class="slideshow">
										<div class="slideset">
				
												<?php $images = get_field('post_gallery'); ?>
						
																<?php
																foreach ($images as $image): ?>
																<div class="slide">
																<img src="<?php
																	echo esc_attr($image['sizes']['large']); ?>" alt="<?php
																	echo esc_attr($image['alt']); ?>" />
																</div>
																	<?php
																endforeach; ?>
							                                 </div>
			
										<ul class="control-nav">
											<?php foreach ($images as $image): ?>
												<li><a href="#">-</a></li>
										<?php endforeach; ?>
										</ul>
										  </div>
								<?php endif;
									}
								 elseif( has_post_thumbnail()) { ?>
								<a href="<?php echo esc_url(get_permalink()); ?>"><?php the_post_thumbnail('investor-blog'); ?></a>
								<?php } ?>
							
							</div>
				         <div class="iv-card-content">
				           <div class="iv-card-title"><?php the_title(); ?></div>
						   <div class="iv-card-text iv-post"><?php the_excerpt(); ?></div>
						    <div class="iv-tags"><?php the_tags( '','   ' ); ?></div>
				         </div>
				