<?php
if (have_rows('pb_content')):
	// loop through the rows of Data
	while (have_rows('pb_content')):
		the_row();
    
		if (get_row_layout() == 'block_content'):
			
	 	   $sclass='';
	 	   if(get_sub_field('light_nav') == 1) {
	 		   $sclass = 'iv-light';
	 	   }
			?>
				<section class="white-section br_editor iv-section <?php echo esc_attr($sclass); ?>" <?php if(get_sub_field('id')) { ?>
		  id="<?php echo esc_attr(get_sub_field('id')); ?>"
					<?php } ?>>
				<div class="center-holder">
					<?php echo get_sub_field('editor_content'); ?>
				</div>
			</section>
	      <?php
		  
		   // COLUMNS
		  
  		elseif (get_row_layout() == 'column_content'):if (get_sub_field('columns')):
	 	   $sclass='';
	 	   if(get_sub_field('light_nav') == 1) {
	 		   $sclass = 'iv-light';
	 	   }
  			?>
  				<section class="white-section br_editor iv-section <?php echo esc_attr($sclass); ?>" <?php if(get_sub_field('id')) { ?>
		  id="<?php echo esc_attr(get_sub_field('id')); ?>"
					<?php } ?>>
  				<div class="investor-content investor-cols">
						<?php 	while (has_sub_field('columns')): ?>
							<div class="investor-col">
  					<?php echo wp_kses_post(get_sub_field('editor_columns')); ?>
				</div>
					<?php endwhile;
					endif; ?>
  				</div>
  			</section>
  	      <?php
												
		
	// ACCORDION
	
	elseif (get_row_layout() == 'accordion_content'):if (get_sub_field('ac_tab')): 
 	   $sclass='';
 	   if(get_sub_field('light_nav') == 1) {
 		   $sclass = 'iv-light';
 	   }
		?>
    <section <?php if(get_sub_field('id')) { ?>
	  id="<?php echo esc_attr(get_sub_field('id')); ?>"
				<?php } ?> class="white-section iv-section <?php echo esc_attr($sclass); ?>">
				<ul class="accordion">
					<?php
					while (has_sub_field('ac_tab')): ?>
					<li>
						<a><?php
							echo esc_attr(get_sub_field('title')); ?></a>
							
								<?php
									echo wp_kses_post(get_sub_field('text')); ?>
								
							</li>
							<?php
						endwhile; ?>
					</ul></section>
					<?php
				endif; ?>
			
				<?php
				
				
				// CONTACT
	
				elseif (get_row_layout() == 'contact_form'): 
					$top      = get_sub_field('padding_top');
					$bottom      = get_sub_field('padding_bottom');
			 	   $sclass='';
			 	   if(get_sub_field('light_nav') == 1) {
			 		   $sclass = 'iv-light';
			 	   }
					?>
			    <section <?php if(get_sub_field('id')) { ?>
				  id="<?php echo esc_attr(get_sub_field('id')); ?>"
							<?php } ?> class="white-section br_editor iv-section <?php echo esc_attr($sclass); ?>" style="padding-top:<?php echo esc_attr($top); ?>px; padding-bottom:<?php echo esc_attr($bottom); ?>px;">
							<div class="investor-form-holder">
						<div class="investor-contact-form">
								<?php
								$dv_form = get_sub_field('dv_select_form');
								
								 echo do_shortcode( '[contact-form-7 title="'.$dv_form.'"]' ); ?>
						
								 
						</div>
					</div>
				
				</section>
						<?php 

						$location = get_sub_field('location');

						if( !empty($location) ):
						?>
						<section iv-section>
						<div class="investor-map">
							<?php $pin = get_theme_mod('highlight_color'); ?>
							<div class="marker" data-lat="<?php echo $location['lat']; ?>" data-lng="<?php echo $location['lng']; ?>" data-color="<?php echo esc_attr($pin); ?>" >
							<h4><?php esc_attr(the_sub_field('title')); ?></h4>
							<p class="address"><?php echo esc_attr($location['address']); ?></p>
							<?php esc_attr(the_sub_field('text')); ?>
							</div>
						</div>
					</section>
						<?php endif; ?>
			
			
			<style type="text/css">

			.investor-map {
				width: 100%;
				height: 400px;
			}

			/* fixes potential theme css conflict */
			.investor-map img {
			   max-width: inherit !important;
			}

			</style>
			<?php $iv_api = esc_attr(get_theme_mod('gmap')); ?>
		<?php if(get_theme_mod('gmap')) { ?>
			<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo $iv_api ?>&callback=initMap"></script>
			<?php } else { ?>
			<script src="https://maps.googleapis.com/maps/api/js?v=3.exp"></script>
			<?php } ?>
			<script type="text/javascript">
			(function($) {

			/*
			*  new_map
			*
			*  This function will render a Google Map onto the selected jQuery element
			*
			*  @type	function
			*  @date	8/11/2013
			*  @since	4.3.0
			*
			*  @param	$el (jQuery element)
			*  @return	n/a
			*/

			function render_map( $el ) {
	
				// var
				var $markers = $el.find('.marker');
			    var dragging = true;

			      
				// vars
				var args = {
					zoom		: 16,
					draggable: dragging,
					scrollwheel: false,
					center		: new google.maps.LatLng(0, 0),
					mapTypeId	: google.maps.MapTypeId.ROADMAP,
		            styles: [{"featureType":"water","elementType":"geometry","stylers":[{"color":"#d6f3f9"},{"lightness":17}]},{"featureType":"landscape","elementType":"geometry","stylers":[{"color":"#f5f5f5"},{"lightness":20}]},{"featureType":"road.highway","elementType":"geometry.fill","stylers":[{"color":"#ffffff"},{"lightness":17}]},{"featureType":"road.highway","elementType":"geometry.stroke","stylers":[{"color":"#ffffff"},{"lightness":29},{"weight":0.2}]},{"featureType":"road.arterial","elementType":"geometry","stylers":[{"color":"#ffffff"},{"lightness":18}]},{"featureType":"road.local","elementType":"geometry","stylers":[{"color":"#ffffff"},{"lightness":16}]},{"featureType":"poi","elementType":"geometry","stylers":[{"color":"#f5f5f5"},{"lightness":21}]},{"featureType":"poi.park","elementType":"geometry","stylers":[{"color":"#dedede"},{"lightness":21}]},{"elementType":"labels.text.stroke","stylers":[{"visibility":"on"},{"color":"#ffffff"},{"lightness":16}]},{"elementType":"labels.text.fill","stylers":[{"saturation":36},{"color":"#333333"},{"lightness":40}]},{"elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"transit","elementType":"geometry","stylers":[{"color":"#f2f2f2"},{"lightness":19}]},{"featureType":"administrative","elementType":"geometry.fill","stylers":[{"color":"#fefefe"},{"lightness":20}]},{"featureType":"administrative","elementType":"geometry.stroke","stylers":[{"color":"#fefefe"},{"lightness":17},{"weight":1.2}]}]
        
				};
	
				// create map	        	
				var map = new google.maps.Map( $el[0], args);
	
	
				// add a markers reference
				map.markers = [];
	
	
				// add markers
				$markers.each(function(){
		
			    	add_marker( $(this), map );
		
				});
	
	
				// center map
				center_map( map );
	
	
				
	
			}
			
			// create info window outside of each - then tell that singular infowindow to swap content based on click
			var infowindow = new google.maps.InfoWindow({
			content		: '' 
			});

			/*
			*  add_marker
			*
			*  This function will add a marker to the selected Google Map
			*
			*  @type	function
			*  @date	8/11/2013
			*  @since	4.3.0
			*
			*  @param	$marker (jQuery element)
			*  @param	map (Google Map object)
			*  @return	n/a
			*/

			function add_marker( $marker, map ) {

				// var
				var latlng = new google.maps.LatLng( $marker.attr('data-lat'), $marker.attr('data-lng') );
				var color = $marker.attr('data-color');
				var mark = pin;
				var icon = {
		            path: mark,
				    fillColor: color,
				    fillOpacity: .8,
				    strokeWeight: 0,
				    scale: .9
				}
				// create marker
				var marker = new google.maps.Marker({
					position	: latlng,
					map			: map,
					icon		: icon,
				});

				// add to array
				map.markers.push( marker );

				// if marker contains HTML, add it to an infoWindow
				if( $marker.html() )
				{
	
	
	

					// show info window when marker is clicked & close other markers
					google.maps.event.addListener(marker, 'click', function() {
						//swap content of that singular infowindow
								infowindow.setContent($marker.html());
						        infowindow.open(map, marker);
					});
	
					// close info window when map is clicked
					     google.maps.event.addListener(map, 'click', function(event) {
					        if (infowindow) {
					            infowindow.close(); }
							}); 
			
		
				}

				}
			/*
			*  center_map
			*
			*  This function will center the map, showing all markers attached to this map
			*
			*  @type	function
			*  @date	8/11/2013
			*  @since	4.3.0
			*
			*  @param	map (Google Map object)
			*  @return	n/a
			*/

			function center_map( map ) {

				// vars
				var bounds = new google.maps.LatLngBounds();

				// loop through all markers and create bounds
				$.each( map.markers, function( i, marker ){

					var latlng = new google.maps.LatLng( marker.position.lat(), marker.position.lng() );

					bounds.extend( latlng );

				});

				// only 1 marker?
				if( map.markers.length == 1 )
				{
					// set center of map
				    map.setCenter( bounds.getCenter() );
				    map.setZoom( 16 );
				}
				else
				{
					// fit to bounds
					map.fitBounds( bounds );
				}

			}

			/*
			*  document ready
			*
			*  This function will render each map when the document is ready (page has loaded)
			*
			*  @type	function
			*  @date	8/11/2013
			*  @since	5.0.0
			*
			*  @param	n/a
			*  @return	n/a
			*/
			// global var
			var map = null;

			$(document).ready(function(){

				$('.investor-map').each(function(){

					// create map
					render_map( $(this) );

				});

			});

			})(jQuery);
			</script>
							<?php
		
		// FEATURES
		
		elseif (get_row_layout() == 'stats_content'):if (get_sub_field('stat')): 
	 	  
	   	 	   $parallax='';
	   	 	   if(get_sub_field('parallax_bg')) :
	   	 		   $parallax = 'parallax-section';
				   else :
					    $parallax='';
				   endif;
			?>
		<section class="section iv-section <?php if(get_sub_field('sc_image')) { ?>bg<?php } ?>"  <?php if(get_sub_field('id')) { ?>
				  id="<?php echo esc_attr(get_sub_field('id')); ?>"
							<?php } ?>>
							<?php if(get_sub_field('sc_image')) { ?>
							<div class="bg-stretch <?php echo esc_attr($parallax); ?>" style="background-image: url(<?php echo esc_attr(get_sub_field('sc_image')); ?>)"></div>
							<?php } ?>
			<div class="holder">
				<div class="container">
					<div class="feature-list">
						<?php
						  while (has_sub_field('stat')): 
				   	 	   $position='center';
				   	 	   if(get_sub_field('ico-left') == 1) {
				   	 		   $position = 'ico-left';
				   	 	   }
							?>
						<div class="feature investor-sr <?php echo esc_attr($position); ?>">
							<div class="icon-holder"><span class="<?php
								echo esc_attr(get_sub_field('icon')); ?>"></span></div>
							<div class="desc">
								<h3><a href="#"><?php
								echo esc_attr(get_sub_field('title')); ?></a></h3>
								<p><?php
									echo esc_attr(get_sub_field('text')); ?></p>
							</div>
						</div>
								<?php
							endwhile; ?>
							<?php
						endif; ?>
					</div>
				</div>
			</div>
		</section>
		

		<?php
	
	//SLIDER
	
	elseif (get_row_layout() == 'slider'):if (get_sub_field('slide')): 
 	  
		?>
	
<div class="iv-section investor slideshow">
	<div class="mask">
		<?php while (has_sub_field('slide')): 
				$slide_img = get_sub_field('image');
				$imgsize = 'full';
				?>
			<div class="slide win-height">
				<div class="bg-stretch iv-dim">
					
					<?php echo wp_get_attachment_image( $slide_img, $imgsize ); ?>
					
				</div>
				<?php $cside = get_sub_field('cap_side');
				
				if(in_array("left", $cside )) { 
					$move = 'left';
				} elseif(in_array("right", $cside )) { 
					$move = 'right';
				} else {
						$move = 'center';
					}
					
				 ?>
				<div class="caption <?php echo esc_attr($move); ?>">
					<div class="holder">
						<h1><?php echo esc_attr(get_sub_field('text')); ?></h1>
						<em class="slogan"><?php echo esc_attr(get_sub_field('subtext')); ?></em>
						<?php if (get_sub_field('buttons')): 
							?>
						<div class="btn-group">
							<?php while (has_sub_field('buttons')): 
								if (get_sub_field('highlight')) {
									$btn_class = 'btn-primary';
								} else {
									$btn_class = 'btn-default';
								}
								?>
							<a href="<?php echo esc_url(get_sub_field('link')); ?>" class="btn <?php echo esc_attr($btn_class); ?>"><?php echo esc_attr(get_sub_field('text')); ?></a>
						<?php endwhile; ?>
							
						</div>
					<?php endif;  ?>
					<?php if (get_sub_field('secsubtext')):  ?>
					<div class="iv-sub-text">
						<p><?php the_sub_field('secsubtext'); ?></p>
					</div>
				<?php endif; ?>
					</div>
					
				</div>
			</div>
			<?php  
		 endwhile; ?>
				
		
	</div>
	<?php if(count( get_sub_field( 'slide' )) > 1) { ?>
	<a class="btn-prev" href="#"><span class="icon-arrow-prev"></span></a>
	<a class="btn-next" href="#"><span class="icon-arrow-next"></span></a>
	<ul class="control-nav">
		<?php while (has_sub_field('slide')): ?>
			<li><a href="#">-</a></li>
	<?php endwhile; ?>
	</ul>
	
	<?php
}
endif;?>
</div>
  
	   
   <?php
   
	//BIG VIDEO
	
	elseif (get_row_layout() == 'hero_header'):  
 	   $sclass='';
 	   if(get_sub_field('light_nav') == 1) {
 		   $sclass = 'iv-light';
 	   }
		?>
	</div>
<div class="iv-section investor slideshow <?php echo esc_attr($sclass); ?>" id="video-bg">
	<div class="mask">
		<?php 
				$image = get_sub_field('image');
				$imgsize = 'full';
				?>
			<div class="slide win-height">
				<div class="bg-stretch iv-dim">
				        <?php  if (get_sub_field('video')): ?>
	 
				        <video autoplay loop muted id="video-background">
				   		  <?php while (has_sub_field('video')):  ?>
				          <source type="video/<?php echo esc_attr(get_sub_field('file_type')); ?>" src="<?php echo esc_url(get_sub_field('url')); ?>"/>
      
				   	   <?php endwhile;?>  
				        </video>
						 <?php  if (get_sub_field('image')) { ?>
						<img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" class="investor-cover">
						<?php } endif;
					?>
					
				</div>
				<div class="caption">
					<div class="holder">
						<h1><?php echo esc_attr(get_sub_field('heading')); ?></h1>
						<em class="slogan"><?php echo esc_attr(get_sub_field('subheading')); ?></em>
							<?php if (get_sub_field('add_button')): 
								?>
							<div class="btn-group">
								<?php while (has_sub_field('add_button')): 
									if (get_sub_field('highlight')) {
										$btn_class = 'btn-primary';
									} else {
										$btn_class = 'btn-default';
									}
									?>
								<a href="<?php echo esc_url(get_sub_field('url')); ?>" class="btn <?php echo esc_attr($btn_class); ?>"><?php echo esc_attr(get_sub_field('text')); ?></a>
							<?php endwhile; ?>
							
							</div>
						<?php endif; ?>
							
						</div>
					
					</div>
				</div>
			</div>
			
				
		
	</div>
	
	

</div>
   <div>
	<?php
	//SPLIT BANNER
	
	elseif (get_row_layout() == 'split_banner'):
		$banner_img = get_sub_field('image');
		$imgsize = 'large';
		$imgvalues = get_sub_field('side');
		$identifier = rand(1, 299);
		$alignment ='right';
		if(in_array("left", $imgvalues )): 
			$alignment = 'left'?>
		<?php endif;
		$sk_left = get_sub_field('left');
		$sk_top = get_sub_field('top');
	
		
		$color = get_sub_field('color');
		$rgb = HTMLToRGB($color);
		$hsl = RGBToHSL($rgb);
		if($hsl->lightness > 200) {
		  $bg = 'bg';
		} else {
			$bg='';
		}
		?>
		
		<section class="section iv-section <?php echo esc_attr($bg); ?>" style="background-color:<?php echo esc_attr(get_sub_field('color')); ?>;" <?php if(get_sub_field('id')) { ?>
	  id="<?php echo esc_attr(get_sub_field('id')); ?>"
				<?php } ?>>
				
			<div class="holder">
				<div class="iv-container">
					<?php if($alignment == 'left') : ?>
					<div class="image" style="background-image:url(<?php the_sub_field('image'); ?>);">
					</div>
				<?php endif; ?>
					<div class="description">
						<div class="holder">
							<h2><?php echo esc_attr(get_sub_field('title')); ?></h2>
							<em class="slogan"><?php the_sub_field('subtitle'); ?></em>
							<?php echo get_sub_field('text'); ?>
							
							<?php if(get_sub_field('button_text')) : ?>
							<a class="btn" href="<?php echo esc_url(get_sub_field('button_link')); ?>" ><?php 
							echo esc_attr(get_sub_field('button_text')); ?></a>
						<?php endif; ?>
						</div>
					</div>
						<?php if($alignment == 'right') : ?>
						<div class="image" style="background-image:url(<?php the_sub_field('image'); ?>);">
						</div>
					<?php endif; ?>
				</div>
			</div>
		</section>
		
		<?php
		
	             	// TESTIMONIALS
							
										elseif (get_row_layout() == 'testimonials_block'):if (get_sub_field('new_testimonial')):
											$tcolor = get_sub_field('background');
											$rgb = HTMLToRGB($tcolor);
											$hsl = RGBToHSL($rgb);
											if(($hsl->lightness < 200) || get_sub_field('sc_image')) {
											  $bg = 'bg';
											}
											
											?>
										    <section class="testimonial section iv-section <?php echo esc_attr($bg); ?>" <?php if(get_sub_field('id')) { ?>
											  id="<?php echo esc_attr(get_sub_field('id')); ?>"
														<?php } ?> style="background-color:<?php echo esc_attr(get_sub_field('background')); ?>;)">
														<div class="bg-stretch parallax-section" style="background-image: url(<?php echo esc_attr(get_sub_field('sc_image')); ?>)">
					
														</div>
										 <div class="t-content">
										   <div class="t-slider single-item">
											<?php  while (has_sub_field('new_testimonial')):
												
												 ?>
												 <div class="quote-container">
										        
										        <div class="quote">
										          <blockquote>
													 <p> <?php echo esc_attr(get_sub_field('testimonial')); ?></p>
										          <cite><span><?php echo esc_attr(get_sub_field('signature')); ?></span><br/><?php echo esc_attr(get_sub_field('company')); ?></cite>
										        </blockquote>
											</div>
				
										      </div>
										   
		<?php
	endwhile; ?>
		
</div>
	
</div>			
										     
										  </section>
										  <?php
endif; ?>
															<?php
		
		//TABLE
	
		elseif (get_row_layout() == 'table'):
			
			?>
		
			<section class="section iv-chart iv-section" <?php if(get_sub_field('id')) { ?>
		  id="<?php echo esc_attr(get_sub_field('id')); ?>"
					<?php } ?>>
					
				<div class="holder">
					<div class="container">
							<div class="holder">
								<h2 class="iv-squeek"><?php echo esc_attr(get_sub_field('title')); ?></h2>
								<p><em class="slogan"><?php echo esc_attr(get_sub_field('subtext')); ?></em></p>
						<?php $table = get_sub_field( 'create_a_table' );

						if ( $table ) { ?>

						  <table border="0">
							  <?php if ( $table['header'] ) { ?>
								<thead>
								 <tr>
                 					<?php  foreach ( $table['header'] as $th) { ?>
										<th>
						                    <?php echo $th['c']; ?>
						                      </th>
										<?php } ?>
									  </tr>
								   </thead>
						     <?php } ?>
							 <tbody>
									<?php  foreach ( $table['body'] as $tr ) { ?>
									  <tr>
										<?php foreach ( $tr as $td ) { ?>
											<td data-label="">
						                           <?php echo $td['c']; ?>
						                      </td>
						                  <?php } ?>  
									  </tr>
						        <?php } ?>   
							</tbody>
						  	</table>
						<?php } ?>
					</div>
			</div>
			</section>
		
		
		<?php
		
		//PIE CHART
	
		elseif (get_row_layout() == 'pie_chart'):
			
			?>
		
			<section class="section iv-chart iv-section" <?php if(get_sub_field('id')) { ?>
		  id="<?php echo esc_attr(get_sub_field('id')); ?>"
					<?php } ?>>
					
				<div class="holder">
					<div class="container">
							<div class="holder">
								<h2 class="iv-squeek"><?php echo esc_attr(get_sub_field('title')); ?></h2>
								<p><em class="slogan"><?php echo esc_attr(get_sub_field('subtext')); ?></em></p>
					    <div class="pieID pie">
      
					    </div>
					    <ul class="pieID legend table-hover">
   						   <?php if (get_sub_field('add_a_slice')):
   				   		 while (has_sub_field('add_a_slice')): ?>
					      <li>
					        <em><?php the_sub_field('label'); ?></em>
					        <span><?php the_sub_field('amount'); ?></span>
					      </li>
					      
  							<?php endwhile;
  						endif;
  							 ?>
					    </ul>
					</div>
			</div>
			</section>

		<?php 
		
		//PARALLAX
	
		elseif (get_row_layout() == 'parallax'): 
	 	  
		   ?>
	
		<section class="section iv-section bg" <?php if(get_sub_field('id')) { ?>
		  id="<?php echo esc_attr(get_sub_field('id')); ?>"
					<?php } ?>>
				<div class="bg-stretch parallax-section" style="background-image: url(<?php echo esc_attr(get_sub_field('sc_image')); ?>)">
					
				</div>
				<div class="holder">
					<div class="container">
						<div class="description">
							<div class="holder">
								<div class="icon-holder">
									<span class="<?php echo esc_attr(get_sub_field('icon')); ?>"></span>
								</div>
								<h2><?php
			echo esc_attr(get_sub_field('title')); ?></h2>
								<p><?php echo esc_attr(get_sub_field('sub_title')); ?></p>
								<?php if(get_sub_field('button_text')) : ?>
								<a href="<?php echo esc_url(get_sub_field('button_link')); ?>" class="button btn-primary"><?php 
					echo esc_attr(get_sub_field('button_text')); ?></a>
				<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</section>
	
		<?php
		
		// PROFILES
		
		elseif (get_row_layout() == 'product_images'):
	 	   
			?>
	<section class="section gray iv-section" <?php if(get_sub_field('id')) { ?>
				  id="<?php echo esc_attr(get_sub_field('id')); ?>"
							<?php } ?>>
		<div class="holder">
			<div class="container">
				<div class="description">
					<div class="holder">
						<h2 class="iv-squeek"><?php echo esc_attr(get_sub_field('title')); ?></h2>
						<p><em class="slogan"><?php echo esc_attr(get_sub_field('subtext')); ?></em></p>
						<ul class="cards">
							 
							    
									   <?php $ids = get_sub_field('link_to_profile');
									
									   if($ids) {
										 foreach($ids as $id) {
										?> 
										<li class="cards-item">
							       <div class="iv-card">
									   
							         <div class="iv-card-image"><a href="<?php echo esc_url(get_permalink($id)); ?>"><img src="<?php the_field('image', $id); ?>" alt="profile"></a></div>
							         <div class="iv-card-content">
							           <div class="iv-card-title"><a href="<?php echo esc_url(get_permalink($id)); ?>"><?php the_field('name', $id); ?></a></div>
									   <div class="iv-card-text"><?php the_field('position', $id); ?></div>
				  					  <?php  if (have_rows('social_icons', $id)): ?>
				  			   		
									   <div class="btn-holder">
								           <div class="icon-parent">
								             <div class="icons">
												 <?php  while (have_rows('social_icons', $id)): the_row(); ?>
													<a href="<?php the_sub_field('social_link'); ?>">
								               <i class="icon-<?php the_sub_field('icon'); ?>" aria-hidden="true"></i>
										   </a>
								              <?php endwhile; ?>
								             </div>
								           </div>
								   </div>
							  
							   <?php endif; ?>
							         </div>
								 </div>
							     </li> 
							 
							       
							
							
						<?php }
					}
						?>
						</ul>
						</div>
					</div>
				</div>
			</div>
	
	</section>
			
	
	<?php
	
	
		// POSTS
		
		elseif (get_row_layout() == 'blog_posts'):
	 	   
			?>
	<section class="section gray iv-section" <?php if(get_sub_field('id')) { ?>
				  id="<?php echo esc_attr(get_sub_field('id')); ?>"
							<?php } ?>>
		<div class="holder">
			<div class="container">
				<div class="description">
					<div class="holder">
						<h2 class="iv-squeek"><?php echo esc_attr(get_sub_field('title')); ?></h2>
						<p><em class="slogan"><?php echo esc_attr(get_sub_field('subtitle')); ?></em></p>
						<ul class="cards">
						   <?php $post_ids = get_sub_field('get_posts');
						   $args = array(
						       'post_type' => array( 'post' ),
						       'orderby' => 'ASC',
						       'post__in' => $post_ids,
							   'posts_per_page' => 3
						   );
						  
                           $loop = new WP_Query( $args );
						   if ( $loop->have_posts() ) : ?>

						  	<!-- the loop -->
						  	<?php while ( $loop->have_posts() ) : $loop->the_post();
								$id = get_the_ID();
							?>
							     <li class="cards-item post">
									
							       <div class="iv-card">
									   <div class="iv-date">
										<?php the_time('M') ?>
										<span><?php the_time('j') ?></span>
										<?php the_time('Y') ?>
									 </div>
									
							         <div class="iv-card-image">
										 
										 <?php the_post_thumbnail('investor-blog'); ?></div>
							         <div class="iv-card-content">
							           <div class="iv-card-title"><a href="<?php echo esc_url(get_permalink()); ?>"><?php the_title(); ?></a></div>
									   <div class="iv-card-text iv-post"><?php the_excerpt(); ?></div>
									    <div class="iv-tags"><?php the_tags( '','   ' ); ?></div>
							         </div>
									 
							       </div>
							     </li>
							
							
						<?php endwhile; endif;  
						
						?>
						<ul>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
			
	
	<?php
	
		// HEADINGS
				
	elseif (get_row_layout() == 'heading_block'):
		$size       = get_sub_field('size');
		$color     = get_sub_field('color');
		$sub_size       = get_sub_field('sub_size');
		$sub_color       = get_sub_field('sub_color');
		$line_size       = get_sub_field('line_size');
		$position       = get_sub_field('alignment');
		$heading_text       = get_sub_field('text');
		$heading_subtext      = get_sub_field('subtext');
		$top      = get_sub_field('padding_top');
		$bottom      = get_sub_field('padding_bottom');
 	   $sclass='';
 	   if(get_sub_field('light_nav') == 1) {
 		   $sclass = 'iv-light';
 	   }
		?>
	    <section class="iv-section <?php echo esc_attr($sclass); ?>" <?php if(get_sub_field('id')) { ?>
		  id="<?php echo esc_attr(get_sub_field('id')); ?>"
					<?php } ?> style="background-color:<?php echo esc_attr(get_sub_field('bg_color')); ?>;background-image:url('<?php echo esc_attr(get_sub_field('background_image')); ?>');">
		<div class="white-section br_editor pg-developer-heading" style="text-align:<?php echo esc_attr($position); ?>; padding-top=:<?php echo esc_attr($top); ?>; padding-bottom:<?php echo esc_attr($bottom); ?>; ">
			<?php 

			$icona = get_sub_field('icon_upload');

			if( !empty($icona) ) { ?>

				<img src="<?php echo esc_url($icona['url']); ?>" alt="<?php echo esc_attr($icona['alt']); ?>" data-sr="move 16px scale up 20%, over 2s">

				<?php } else { ?>
				<span class="icon fa <?php
					echo esc_attr(get_sub_field('icon')); ?>"></span>
				<?php } ?>
		<h2 style="font-size:<?php echo esc_attr($size); ?>px;color:<?php echo esc_attr($color); ?>;"><?php echo esc_attr($heading_text); ?></h2>
		<span style="font-size:<?php echo esc_attr($sub_size); ?>px;line-height:<?php echo esc_attr($line_size);?>px;color:<?php echo esc_attr($sub_color); ?>;"><?php echo esc_attr(wp_strip_all_tags($heading_subtext)); ?></span>
	</div>
	</section>
		<?php	
		
		// SKINNY BANNER
				
	elseif (get_row_layout() == 'investor_banner'):
 	   $sclass='';
 	   if(get_sub_field('light_nav') == 1) {
 		   $sclass = 'iv-light';
 	   }
		?>
	<div class="banner iv-section <?php echo esc_attr($sclass); ?>" style="background-color:<?php echo get_sub_field('color'); ?>;">
		<span class="title" style="color:<?php echo get_sub_field('font_color'); ?>;"><?php the_sub_field('title'); ?></span>
	</div>
	
	<?php
	             	

endif; ?>
 <?php
endwhile; else :
// no layouts found
endif;

?> 