<?php
/**
 * Investor functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package investor
 */

if ( ! function_exists( 'investor_setup' ) ) :
	
/*--------------------------*
/* Theme Setup
/*--------------------------*/
	
function investor_setup() {
	
	load_theme_textdomain( 'investor', get_template_directory() . '/languages' );
	
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
    add_image_size('investor-header', 1024, 678, true);
	add_image_size('investor-blog', 500, 240, true);

	register_nav_menus( array(
		'primary' => esc_html__( 'Primary', 'investor' ),
		'header' => esc_html__( 'Header', 'investor' ),
		'footer' => esc_html__( 'Footer', 'investor' ),
	) );
   
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	add_theme_support( 'post-formats', array(
		'gallery',
		'video',
	) );

}
endif;
add_action( 'after_setup_theme', 'investor_setup' );

function investor_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'investor_content_width', 640 );
}
add_action( 'after_setup_theme', 'investor_content_width', 0 );

/*--------------------------*
/* Register Widget Areas
/*--------------------------*/

function investor_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'investor' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer 1', 'investor' ),
		'id'            => 'footer-main',
		'before_widget' => '<nav id="%1$s" class="footer-nav widget %2$s">',
		'after_widget'  => '</nav>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer 2', 'investor' ),
		'id'            => 'footer-right',
		'before_widget' => '<nav id="%1$s" class="footer-nav widget %2$s">',
		'after_widget'  => '</nav>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'investor_widgets_init' );

/*--------------------------*
/* Register Fonts
/*--------------------------*/

function investor_fonts_url() {
$font_url = '';

if ( 'off' !== _x( 'on', 'Google font: on or off', 'investor' ) ) {
    $font_url = add_query_arg( 'family', urlencode( 'Work Sans:300,400&subset=latin,latin-ext' ), "//fonts.googleapis.com/css" );
}
return $font_url;
}

/*--------------------------*
/* Enqueue Scripts/Styles
/*--------------------------*/

function investor_scripts() {
	wp_enqueue_style( 'investor-style', get_stylesheet_uri() );
	wp_enqueue_script( 'investor-main', get_template_directory_uri() . '/js/jquery.investor.js', array('jquery'), '20160303', true );
	$site_parameters = array(
	    'site_url' => get_site_url(),
	    'theme_directory' => get_template_directory_uri()
	    );
	wp_localize_script( 'investor-main', 'SiteParameters', $site_parameters );

		

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	wp_enqueue_script( 'scroll-reveal', get_template_directory_uri() . '/js/scrollreveal.min.js', array('jquery'), '20160303', false );
	wp_enqueue_style( 'investor-fonts', investor_fonts_url(), array(), '1.0.0' );
}
add_action( 'wp_enqueue_scripts', 'investor_scripts' );

/*--------------------------*
/* Enqueue Admin Scripts/Styles
/*--------------------------*/

function investor_admin_scripts_loader($hook){
    if(in_array($hook,array("post-new.php","post.php","edit.php"))) {
		wp_enqueue_style('investor-style', get_template_directory_uri() . '/admin/css/jquery.fonticonpicker.min.css');
		wp_enqueue_style('investor-theme-style', get_template_directory_uri() . '/admin/css/themes/grey-theme/jquery.fonticonpicker.grey.min.css');
		wp_enqueue_style('investor-icons', get_template_directory_uri() . '/admin/css/icomoon.css');
        wp_enqueue_script('investorscript', get_template_directory_uri() . '/admin/js/jquery.fonticonpicker.min.js', array('jquery'), '20160303', false );
		wp_enqueue_script('investor-icon-script', get_template_directory_uri() . '/admin/js/icon-select.js', array('jquery'), '20160303', false );
	    $post_id = $_GET['post'] ? $_GET['post'] : $_POST['post_ID'] ;
        $template_file = get_post_meta($post_id,'_wp_page_template',TRUE);
	       if ($template_file == 'page-fund.php') {
	   	   wp_enqueue_style('investor-pb', get_template_directory_uri() .'/admin/css/pb.css');		
	   	}
		
	 }
}
add_action("admin_enqueue_scripts","investor_admin_scripts_loader");

/*--------------------------*
/* Custom Header
/*--------------------------*/

require get_template_directory() . '/inc/custom-header.php';

/*--------------------------*
/* Custom Template Tags
/*--------------------------*/

require get_template_directory() . '/inc/template-tags.php';

/*--------------------------*
/* Custom Independant Functions
/*--------------------------*/

require get_template_directory() . '/inc/extras.php';

/*--------------------------*
/* Customizer
/*--------------------------*/

require get_template_directory() . '/inc/customizer.php';

/*--------------------------*
/* Plugins
/*--------------------------*/

require get_template_directory() . '/inc/plugins/plugin.php';

/*--------------------------*
/* Jetpack Compatibility
/*--------------------------*/

require get_template_directory() . '/inc/jetpack.php';

/*--------------------------*
/* Custom Fields
/*--------------------------*/

$value= '';
require get_template_directory() . '/inc/custom-fields.php';

/*--------------------------*
/* Map API
/*--------------------------*/

function iv_acf_init() {
	$iv_map_api = get_theme_mod('gmap');
	acf_update_setting('google_api_key', $iv_map_api);
}

add_action('acf/init', 'iv_acf_init');

/*--------------------------*
/* Page Builder Contact Form Select
/*--------------------------*/

function investor_acf_load_contact_field( $field )
{
	// Reset choices
	$field['choices'] = array();
 
	$post_type = 'wpcf7_contact_form';
	
	$args = array (
		'post_type' => $post_type,
		'posts_per_page' => -1,
		'orderby' => 'menu_order',
		'order' => 'ASC',
	);
	
	$contact_forms = get_posts($args);
	
	$choices = array();
	foreach( $contact_forms as $form) {
		$choices[$form->ID] = strip_tags($form->post_title);
	}
	// loop through array and add to field 'choices'
	if( is_array($choices) )
	{
		$field['choices']['none'] = 'none';
		foreach( $choices as $choice )
		{
			$field['choices'][ $choice ] = $choice;
		}
	}
 
    // Important: return the field
    return $field;
}
 
add_filter('acf/load_field/name=dv_select_form', 'investor_acf_load_contact_field');

/*--------------------------*
/* Get Profile pages
/*--------------------------*/ 
  
  add_filter('acf/fields/post_object/query/name=link_to_profile', 'investor_relationship_query', 10, 3);
  function investor_relationship_query($args, $field, $post) {
      
	  // show only pages with this special template
	 	    $args['meta_key'] = '_wp_page_template';
	 	    $args['meta_value'] = 'page-profile.php';
	 	    return $args;
      
  }
  

/*--------------------------*
/* Admin Styles
/*--------------------------*/
function investor_customizer_css()
{
	wp_enqueue_style( 'custom-style', get_template_directory_uri() . '/css/custom-style.css' );
	
   require_once get_template_directory() . '/inc/custom-styles.php';


wp_add_inline_style( 'custom-style', $custom_inline_style );

}
	
add_action( 'wp_enqueue_scripts', 'investor_customizer_css');

function investor_admin_css() {
    wp_enqueue_style('pg-developer-admin-style', get_template_directory_uri() . '/css/admin-style.css');
}
add_action('admin_enqueue_scripts', 'investor_admin_css');

/*--------------------------*
/* More Link
/*--------------------------*/

function new_excerpt_more($more) {
       global $post;
	return '<a class="moretag" href="'. get_permalink($post->ID) . '">&nbsp;  Read more &#10141; </a>';
}
add_filter('excerpt_more', 'new_excerpt_more');

/*--------------------------*
/* Yoast SEO Extension
/*--------------------------*/

function investor_yoastseo_acf() {
	wp_enqueue_script( 'acf_yoastseo', get_template_directory_uri() . '/js/acf_yoastseo.js', 'jquery' );
}

add_action( 'admin_init', 'investor_yoastseo_acf' );

 
function investor_format_value( $value, $post_id, $field ) {
	
	return esc_attr($value);
	
}

add_filter('acf/format_value/type=text', 'investor_format_value', 10, 3);

/*--------------------------*
/* Determine Lightness of Background
/*--------------------------*/

function HTMLToRGB($htmlCode)
  {
    if($htmlCode[0] == '#')
      $htmlCode = substr($htmlCode, 1);

    if (strlen($htmlCode) == 3)
    {
      $htmlCode = $htmlCode[0] . $htmlCode[0] . $htmlCode[1] . $htmlCode[1] . $htmlCode[2] . $htmlCode[2];
    }

    $r = hexdec($htmlCode[0] . $htmlCode[1]);
    $g = hexdec($htmlCode[2] . $htmlCode[3]);
    $b = hexdec($htmlCode[4] . $htmlCode[5]);

    return $b + ($g << 0x8) + ($r << 0x10);
  }

function RGBToHSL($RGB) {
    $r = 0xFF & ($RGB >> 0x10);
    $g = 0xFF & ($RGB >> 0x8);
    $b = 0xFF & $RGB;

    $r = ((float)$r) / 255.0;
    $g = ((float)$g) / 255.0;
    $b = ((float)$b) / 255.0;

    $maxC = max($r, $g, $b);
    $minC = min($r, $g, $b);

    $l = ($maxC + $minC) / 2.0;

    if($maxC == $minC)
    {
      $s = 0;
      $h = 0;
    }
    else
    {
      if($l < .5)
      {
        $s = ($maxC - $minC) / ($maxC + $minC);
      }
      else
      {
        $s = ($maxC - $minC) / (2.0 - $maxC - $minC);
      }
      if($r == $maxC)
        $h = ($g - $b) / ($maxC - $minC);
      if($g == $maxC)
        $h = 2.0 + ($b - $r) / ($maxC - $minC);
      if($b == $maxC)
        $h = 4.0 + ($r - $g) / ($maxC - $minC);

      $h = $h / 6.0; 
    }

    $h = (int)round(255.0 * $h);
    $s = (int)round(255.0 * $s);
    $l = (int)round(255.0 * $l);

    return (object) Array('hue' => $h, 'saturation' => $s, 'lightness' => $l);
  }
