<?php
/**
 * Template Name: Events Template
 *
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Investor
 */
get_header();

if( has_post_thumbnail()) {
	$thumb = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'large' );
	$url = $thumb['0'];
}
elseif(get_header_image()) {
	$url = get_header_image();
}
?>
	
		<header class="iv-fade iv-adjust">
		  <div class="headline" style="background:url(<?php echo esc_url($url);?>) no-repeat center center / cover;">
		    <div class="inner">
		     <?php the_title( '<h1>','</h1>' ); ?>
		      <p><?php if ( function_exists( 'get_field' )  ) { echo esc_attr(get_field('page_subtitle')); } ?></p>
		    </div>
		  </div>
		</header>
		
			 	<main id="main">
		
			 		<div id="content">
			 			<div class="container">

			 		<?php
			 		if ( have_posts() ) :

			 			/* Start the Loop */
			 			while ( have_posts() ) : the_post();

			 				/*
			 				 * Include the Post-Format-specific template for the content.
			 				 * If you want to override this in a child theme, then include a file
			 				 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
			 				 */
			 				get_template_part( 'template-parts/content', 'event' );

			 			endwhile;
			
			

			 		else :

			 			get_template_part( 'template-parts/content', 'none' );

			 		endif; ?>
			 				</div>
				
			 				<?php investor_paging_nav(); ?>
				
			 	</div><!-- #primary -->
	
			 		</main><!-- #main -->
	

			 <?php
			 //get_sidebar();
			 get_footer();