<?php
/**
 * Template part for displaying events.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Investor
 */


if( have_rows('new_event') ):

 	// loop through the rows of data
    while ( have_rows('new_event') ) : the_row();
	$event_img = get_sub_field('image');
	$event_imgsize = 'large';
	$title = get_sub_field('title', false, false);
	$date = get_sub_field('date');
	$payment = get_sub_field('payment');
?>
					<article id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>>
						<div class="detail">
							<time><?php the_sub_field('date'); ?></time>
							<h2><?php the_sub_field('title'); ?></h2>
							<?php the_sub_field('location'); ?>
							<?php if(get_sub_field('payment')) :
								echo do_shortcode('[stripe name="'.$title.'" description="'.$date.'" amount="'.$payment.'"][stripe_number label="Quantity" is_quantity="true" default="1"][/stripe]');
							endif; ?>
						</div>
						<div class="text">
							<div class="image-holder">
						 		<?php echo wp_get_attachment_image( $event_img, $event_imgsize );  ?>
							</div>
							<?php the_sub_field('description'); ?>
						</div>
					</article>
					
					<?php
				endwhile;

				else : 
                
				echo esc_html__( 'No Events Found', 'investor' );
					
		
				endif;
					?>